<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DeliveryExternal extends Model 
{

    protected $table = 'delivery_external';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('level_id', 'price');

    public function level()
    {
        return $this->belongsTo('DeliveryLevel', 'level_id');
    }

}