<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Promotion extends Model 
{

    protected $table = 'promotion';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'from_date', 'to_date', 'store_id');

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

}