<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HelpCategory extends Model 
{

    protected $table = 'help_category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar');

    public function questions()
    {
        return $this->hasMany('HelpQuestion', 'help_category_id');
    }

}