<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HelpQuestion extends Model 
{

    protected $table = 'help_question';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('help_category_id', 'question_en', 'answer_en', 'question_ar', 'answer_ar');

    public function help_category()
    {
        return $this->belongsTo('HelpCategory', 'help_category_id');
    }

}