<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Option extends Model 
{

    protected $table = 'option';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('option_category_id', 'name_en', 'name_ar', 'description_en', 'description_ar');

    public function option_category()
    {
        return $this->belongsTo('OptionCategory', 'option_category_id');
    }

}