<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Discount extends Model 
{

    protected $table = 'discount';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('store_id', 'name', 'code', 'discount_type', 'amount', 'from_date', 'to_date');

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

}