<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfferTable extends Migration {

	public function up()
	{
		Schema::create('offer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->datetime('from_date')->nullable();
			$table->datetime('to_date')->nullable();
			$table->integer('category_id')->nullable();
			$table->integer('store_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('offer');
	}
}