<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('product', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->integer('category_id')->nullable();
			$table->double('price')->nullable();
			$table->integer('prepared_time')->nullable();
			$table->integer('max_pieces')->nullable();
			$table->integer('max_days')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->boolean('show')->default(1);
			$table->double('price_discount')->nullable();
			$table->integer('store_id')->nullable();
			$table->string('product_code')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('product');
	}
}