<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDriverTable extends Migration {

	public function up()
	{
		Schema::create('driver', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('phone')->nullable();
			$table->string('email')->nullable();
			$table->enum('status', array('active', 'inactive'))->nullable();
			$table->string('password')->nullable();
			$table->integer('rate')->nullable();
			$table->integer('city_id')->nullable();
			$table->text('address')->nullable();
			$table->integer('store_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('driver');
	}
}