<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'store_id', 'parent_id');

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

	public function parent()
	{
		return $this->belongsTo('Category', 'parent_id');
	}

	public function subcategories()
	{
		return $this->hasMany('Category', 'parent_id');
	}

	public function products()
	{
		return $this->hasMany('Product', 'category_id');
	}

	public function offers()
	{
		return $this->hasMany('Offer', 'category_id');
	}

}