<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class City extends Eloquent {

	protected $table = 'city';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'country_id', 'geofence');

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}