<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class HelpCategory extends Eloquent {

	protected $table = 'help_category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar');

	public function questions()
	{
		return $this->hasMany('HelpQuestion', 'help_category_id');
	}

}