<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class HelpQuestion extends Eloquent {

	protected $table = 'help_question';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('help_category_id', 'question_en', 'answer_en', 'question_ar', 'answer_ar');

	public function help_category()
	{
		return $this->belongsTo('HelpCategory', 'help_category_id');
	}

}