<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Offer extends Eloquent {

	protected $table = 'offer';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'from_date', 'to_date', 'category_id', 'store_id');

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}