<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderCancel extends Eloquent {

	protected $table = 'order_cancel';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('reason_id', 'order_id', 'review');

	public function reason()
	{
		return $this->belongsTo('CancelReason', 'reason_id');
	}

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

}