<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'product';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'category_id', 'price', 'prepared_time', 'max_pieces', 'max_days', 'description_en', 'description_ar', 'show', 'price_discount', 'store_id', 'product_code');

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

	public function options()
	{
		return $this->hasMany('ProductOption', 'product_id');
	}

}