<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Promotion extends Eloquent {

	protected $table = 'promotion';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'from_date', 'to_date', 'store_id');

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

}