<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoreTable extends Migration {

	public function up()
	{
		Schema::create('store', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('available', array('available', 'unavailable'))->nullable();
			$table->boolean('parent_id')->nullable();
			$table->integer('country_id')->nullable();
			$table->string('password')->nullable();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('phone')->nullable();
			$table->string('email')->nullable();
			$table->integer('store_category_id')->nullable();
			$table->double('min_charge')->nullable();
			$table->enum('status', array('open', 'closed', 'busy'))->nullable();
			$table->integer('rate')->nullable();
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->integer('city_id')->nullable();
			$table->string('address_en')->nullable();
			$table->string('address_ar')->nullable();
			$table->enum('delivery_type', array('internal', 'external'))->nullable();
			$table->double('min_delivery')->nullable();
			$table->enum('duration', array('days', 'mins', 'hours'))->nullable();
			$table->integer('from')->nullable();
			$table->integer('to')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->string('com_email')->nullable();
			$table->string('com_phone')->nullable();
			$table->integer('package_id')->nullable();
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('store');
	}
}