<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Discount extends Eloquent {

	protected $table = 'discount';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('store_id', 'name', 'code', 'discount_type', 'amount', 'from_date', 'to_date');

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

}