<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Driver extends Eloquent {

	protected $table = 'driver';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'phone', 'email', 'status', 'password', 'rate', 'city_id', 'address', 'store_id', 'user_id', 'latitude', 'longitude');

	public function from_cities()
	{
		return $this->belongsToMany('City', 'take_from', 'driver_id', 'city_id');
	}

	public function to_cities()
	{
		return $this->belongsToMany('City', 'delivery_to', 'driver_id', 'city_id');
	}

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

}