<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderReject extends Eloquent {

	protected $table = 'order_reject';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('reason_id', 'order_id', 'review');

	public function reason()
	{
		return $this->belongsTo('RejectReason', 'reason_id');
	}

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

}