<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountTable extends Migration {

	public function up()
	{
		Schema::create('discount', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('store_id')->nullable();
			$table->string('name')->nullable();
			$table->string('code')->nullable();
			$table->enum('discount_type', array('fixed', 'percent'))->nullable();
			$table->integer('amount')->nullable();
			$table->datetime('from_date')->nullable();
			$table->datetime('to_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('discount');
	}
}