<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Massege extends Eloquent {

	protected $table = 'message';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('from_user', 'to_user', 'type', 'message', 'order_id');

	public function from_user()
	{
		return $this->belongsTo('User', 'from_user');
	}

	public function to_user()
	{
		return $this->belongsTo('User', 'to_user');
	}

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

}