<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Schedule extends Eloquent {

	protected $table = 'schedule';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('from_hour', 'to_hour', 'day_off', 'store_id');

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

}