<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'client';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'phone', 'email', 'city_id', 'point', 'rate', 'user_id');

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function addresses()
    {
        return $this->hasMany('Address', 'client_id');
    }

}