<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StoreCity extends Model 
{

    protected $table = 'store_city';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('city_id', 'store_id');

    public function store()
    {
        return $this->belongsTo('Store', 'store_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

}