<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->string('client_name');
			$table->string('client_age');
			$table->integer('blood_type_id')->unsigned();
			$table->integer('bags_count');
			$table->decimal('hospital_latitude', 10,8);
			$table->decimal('hospital_longitude', 10,8);
			$table->integer('city_id')->unsigned();
			$table->string('client_phone');
			$table->string('comment');
			$table->string('hospital_name');
			$table->string('address');
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}