<?php

namespace App\Models;

class Donation-Request extends Eloquent {

	protected $table = 'donations_requests';
	public $timestamps = true;
	protected $fillable = array('patient_name', 'patient_age', 'patient_phone', 'hospital_address', 'hospital_name', 'bugs_num', 'details', 'latitude', 'longitude');

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function blood_type()
	{
		return $this->belongsTo('App\Models\Blood_Type');
	}

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification');
	}

}