<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('reason');
			$table->integer('quantity')->unsigned();
			$table->integer('sku_id')->unsigned();
			$table->integer('location_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}