<?php

namespace App\Models;

class ProductVariant extends Eloquent {

	protected $table = 'product_variants';
	public $timestamps = true;
	protected $fillable = array('product_id', 'variant_name_id');

	public function product()
	{
		return $this->belongsTo('App\Models\Product');
	}

	public function variantValues()
	{
		return $this->hasMany('App\Models\ProductVariantValue');
	}

	public function variantName()
	{
		return $this->belongsTo('App\Models\VariantName');
	}

}