<?php

namespace App\Models;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;
	protected $fillable = array('brand_id', 'name', 'description', 'category_id', 'barcode_template');

	public function brand()
	{
		return $this->belongsTo('App\Models\Brand');
	}

	public function variants()
	{
		return $this->hasMany('App\Models\ProductVariant');
	}

	public function attributes()
	{
		return $this->hasMany('App\Models\ProductAttribute');
	}

}