<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSkusTable extends Migration {

	public function up()
	{
		Schema::create('skus', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('product_id')->unsigned();
			$table->string('barcode', 20)->unique();
			$table->decimal('price', 8,2)->default('0.00');
		});
	}

	public function down()
	{
		Schema::drop('skus');
	}
}