<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractRescissionCompositionTable extends Migration {

	public function up()
	{
		Schema::create('contract_rescission_composition', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('rescision_id')->unsigned()->index();
			$table->char('code', 6);
			$table->string('title', 191);
			$table->float('value', 8,2)->default('0');
			$table->boolean('type')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contract_rescission_composition');
	}
}