<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractSalaryTablesTable extends Migration {

	public function up()
	{
		Schema::create('contract_salary_tables', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('contract_id')->unsigned()->index();
			$table->date('begin_date');
			$table->date('end_date')->nullable();
			$table->string('reason', 191)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contract_salary_tables');
	}
}