<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractChangesTable extends Migration {

	public function up()
	{
		Schema::create('contract_changes', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('contract_id')->unsigned()->index();
			$table->date('modification_date');
			$table->tinyInteger('contract_type')->unsigned()->default('0');
			$table->boolean('experience_renovation')->default(0);
			$table->tinyInteger('renovation_days')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contract_changes');
	}
}