<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractInterruptionsTable extends Migration {

	public function up()
	{
		Schema::create('contract_interruptions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('contract_id')->unsigned()->index();
			$table->string('reason', 191);
			$table->datetime('begin_interruption_date');
			$table->datetime('end_interruption_date')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contract_interruptions');
	}
}