<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('person_documents', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('person_id')->unsigned();
			$table->char('rg', 20)->nullable();
			$table->char('rg_dispatcher', 20)->nullable();
			$table->char('ctps_number', 8)->nullable();
			$table->char('ctps_series', 5)->nullable();
			$table->char('ctps_uf', 2)->nullable();
			$table->char('cpf', 11)->nullable();
			$table->char('cnpj', 11)->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->char('pis_pasep', 11);
		});
	}

	public function down()
	{
		Schema::drop('person_documents');
	}
}