<?php

namespace Merchant\Entities;

class ContractChange extends Eloquent {

	protected $table = 'contract_changes';
	public $timestamps = true;
	protected $fillable = array('contract_id', 'modification_date', 'contract_type', 'experience_renovation', 'renovation_days');
	protected $visible = array('contract_id', 'modification_date', 'contract_type', 'experience_renovation', 'renovation_days');

	public function contract()
	{
		return $this->belongsTo('EmployeeContract', 'contract_id', 'id');
	}

}