<?php

namespace Merchant\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EmployeeContract extends Eloquent {

	protected $table = 'employee_contracts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('employee_id', 'registration_id', 'begin_date', 'end_date', 'contract_type', 'begin_in_experience', 'begin_experience_days', 'determined_time');
	protected $visible = array('employee_id', 'registration_id', 'begin_date', 'end_date', 'contract_type', 'begin_in_experience', 'begin_experience_days', 'determined_time');

	public function employee()
	{
		return $this->belongsTo('Merchant\Entities\Employee', 'employee_id', 'id');
	}

}