<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractRolesTable extends Migration {

	public function up()
	{
		Schema::create('contract_roles', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('contract_id')->unsigned()->index();
			$table->string('name', 191);
			$table->date('begin_date');
			$table->date('end_date')->nullable();
			$table->string('reason', 191)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contract_roles');
	}
}