<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractSuspensionsTable extends Migration {

	public function up()
	{
		Schema::create('contract_suspensions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('contract_id')->unsigned()->index();
			$table->string('reason', 191);
			$table->datetime('begin_suspension_date');
			$table->datetime('end_suspension_date')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contract_suspensions');
	}
}