<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractVacationsTable extends Migration {

	public function up()
	{
		Schema::create('contract_vacations', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('contract_id')->unsigned()->index();
			$table->date('begin_acquisition_date');
			$table->date('end_acquisition_date')->nullable();
			$table->date('begin_concession_date')->nullable();
			$table->date('end_concession_date')->nullable();
			$table->boolean('enjoyed')->default(0);
			$table->date('begin_enjoy_date')->nullable();
			$table->date('end_enjoy_date')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contract_vacations');
	}
}