<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeeContractsTable extends Migration {

	public function up()
	{
		Schema::create('employee_contracts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('employee_id')->unsigned();
			$table->integer('registration_id')->unsigned();
			$table->date('begin_date');
			$table->date('end_date')->nullable();
			$table->integer('contract_type')->default('0');
			$table->boolean('begin_in_experience')->default(0);
			$table->tinyInteger('begin_experience_days')->nullable();
			$table->boolean('determined_time')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('employee_contracts');
	}
}