<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePeopleTable extends Migration {

	public function up()
	{
		Schema::create('people', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('fist_name', 191);
			$table->string('last_name', 191);
			$table->string('fantasy_name', 191)->nullable();
			$table->boolean('type')->default(0);
			$table->boolean('gender');
			$table->date('birth_date');
			$table->tinyInteger('civil_status')->default('0');
			$table->string('nationality', 191);
			$table->string('naturalness', 191);
			$table->string('mother_name', 191)->nullable();
			$table->string('father_name', 191)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('people');
	}
}