<?php

namespace Merchant\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ContractRescissionComposition extends Eloquent {

	protected $table = 'contract_rescission_composition';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('rescision_id', 'code', 'title', 'value', 'type');
	protected $visible = array('rescision_id', 'code', 'title', 'value', 'type');

	public function rescision()
	{
		return $this->belongsTo('ContractRescission', 'rescision_id', 'id');
	}

}