<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientsTable extends Migration {

	public function up()
	{
		Schema::create('patients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email')->unique();
			$table->string('password');
			$table->string('phone');
			$table->string('image');
			$table->tinyInteger('gender')->nullable()->default('0');
			$table->tinyInteger('status')->nullable()->default('0');
			$table->string('address')->nullable();
			$table->date('dob');
		});
	}

	public function down()
	{
		Schema::drop('patients');
	}
}