<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('doctor_schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('doctor_id')->unsigned();
			$table->date('date');
			$table->string('start_time');
			$table->string('end_time');
			$table->string('average_consulting_time');
			$table->tinyInteger('status')->default('0');
			$table->enum('day', array('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'));
		});
	}

	public function down()
	{
		Schema::drop('doctor_schedules');
	}
}