<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Questionable extends Model 
{

    protected $table = 'questionables';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function belongable()
    {
        return $this->morphTo();
    }

    public function question()
    {
        return $this->belongsTo('Question');
    }

}