<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Questionable extends Eloquent {

	protected $table = 'questionables';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function belongable()
	{
		return $this->morphTo();
	}

	public function question()
	{
		return $this->belongsTo('Question');
	}

}