<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Question extends Eloquent {

	protected $table = 'questions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function type()
	{
		return $this->belongsTo('QuestionType');
	}

	public function answers()
	{
		return $this->hasMany('QuestionAnswer');
	}

	public function answereds()
	{
		return $this->hasMany('QuestionUserAnswer');
	}

	public function belongings()
	{
		return $this->hasMany('Questionable');
	}

}